#!/bin/perl
#
# Parse OCR information of scanned documents and tag/rename files 
#
use strict;
use Getopt::Std;
use POSIX qw(strftime);
use File::Basename;

#
# Variables/Constants
#
my $now=strftime("%c",localtime);
our $prog=basename $0;
our %cover;
our %time;
our %switch;
our %light;
our %sensor;
our %binary_sensor;
our $manufacturer="PEHA";


$binary_sensor{'imd.2.0'}="Küche Taster oben";
$binary_sensor{'imd.2.3'}="Arbeitszimmer Taster";
$binary_sensor{'imd.2.7'}="WC Fenster";
$binary_sensor{'imd.4.0'}="Küche Fenster Nord";
$binary_sensor{'imd.4.1'}="Küche Fenster Ost";
$binary_sensor{'imd.4.10'}="Schlafzimmer Fenster";
$binary_sensor{'imd.4.11'}="Franjo Fenster";
$binary_sensor{'imd.4.12'}="Christian Fenster";
$binary_sensor{'imd.4.14'}="Garage Garagentor";
$binary_sensor{'imd.4.15'}="Garage Seitentür";
$binary_sensor{'imd.4.2'}="Arbeitszimmer Fenster";
$binary_sensor{'imd.4.4'}="Garage Seitentür Verriegelung";
$binary_sensor{'imd.4.5'}="Wohnzimmer Terrassentür links";
$binary_sensor{'imd.4.6'}="Wohnzimmer Terrassentür rechts";
$binary_sensor{'imd.4.8'}="Bad Fenster";
$binary_sensor{'imd.4.9'}="Lea Fenster";

$cover{'jrm.4.0'}="Küche Rolladen Ost"; $time{'jrm.4.0'}=300;
$cover{'jrm.4.1'}="Küche Rolladen Nord"; $time{'jrm.4.1'}=300;
$cover{'jrm.4.2'}="Bad Rolladen"; $time{'jrm.4.2'}=300;
$cover{'jrm.4.3'}="Schlafzimmer Rolladen"; $time{'jrm.4.3'}=300;
$cover{'jrm.5.2'}="Wohnzimmer Rolladen rechts"; $time{'jrm.5.2'}=300;
$cover{'jrm.5.3'}="Wohnzimmer Rolladen links"; $time{'jrm.5.3'}=300;
$cover{'jrm.6.0'}="HWR Rolladen"; $time{'jrm.6.0'}=300;
$cover{'jrm.6.1'}="Arbeitszimmer Rolladen"; $time{'jrm.6.1'}=300;

$light{'omd.0.0'}="Küche Licht";
$light{'omd.0.2'}="Diele Licht";
$light{'omd.0.3'}="WC Licht";
$light{'omd.1.0'}="Küche Licht Hängeschrank rechts";
$light{'omd.1.1'}="Garten Kugelleuchten";
$light{'omd.1.2'}="Christian Licht";
$light{'omd.1.3'}="Galerie Licht";
$light{'omd.1.6'}="Dachboden Licht";
$light{'omd.1.7'}="Garten Wegeleuchten";
$light{'omd.2.0'}="Lea Licht";
$light{'omd.2.1'}="Franjo Licht";
$light{'omd.2.2'}="Wohnzimmer Schrankbeleuchtung";
$light{'omd.2.6'}="Wohnzimmer Stehlampe";
$light{'omd.3.0'}="HWR Licht";
$light{'omd.3.1'}="Garage Dachboden Licht";
$light{'omd.3.2'}="Bad Licht";
$light{'omd.3.4'}="Garage Licht";
$light{'omd.3.5'}="Hof Aussenbeleuchtung Hintereingang";
$light{'omd.3.7'}="Schlafzimmer Licht";
$light{'omd.7.0'}="Wohnzimmer Licht Esstisch";
$light{'omd.7.2'}="Arbeitszimmer Licht";
$light{'omd.7.3'}="Wohnzimmer Licht Couch";

$sensor{'imd.2.0'}="Küche Taster oben";
$sensor{'imd.2.3'}="Arbeitszimmer Taster";
$sensor{'imd.2.5'}="WC Taster";
$sensor{'imd.4.1'}="Küche Fenster Ost";
$sensor{'imd.4.2'}="Arbeitszimmer Fenster";
$sensor{'imd.9.5'}="Arbeitszimmer Taster virtuell";

$switch{'imd.0.1'}="Garage LED links";
$switch{'imd.0.2'}="Garage LED rechts";
$switch{'imd.0.3'}="Diele LED oben";
$switch{'imd.0.4'}="Diele LED unten";
$switch{'imd.0.5'}="Dachboden LED";
$switch{'imd.0.7'}="Bad LED";
$switch{'imd.1.3'}="HWR LED Garage";
$switch{'imd.2.3'}="Arbeitszimmer LED";
$switch{'imd.2.5'}="WC LED";
$switch{'imd.3.3'}="Wohnzimmer LED Fliegengitter";

$switch{'omd.0.4'}="Garten Steckdose Vorgarten";
$switch{'omd.0.5'}="Terrasse Springbrunnen";
$switch{'omd.0.6'}="Küche Steckdose Nord";
$switch{'omd.0.7'}="Diele Steckdose";
$switch{'omd.1.4'}="Küche Steckdose Herd";
$switch{'omd.1.5'}="Arbeitszimmer PC";
$switch{'omd.2.3'}="Wohnzimmer Steckdose Südwest";
$switch{'omd.2.5'}="Franjo Steckdose";
$switch{'omd.2.7'}="Wohnzimmer Steckdose TV";
$switch{'omd.3.3'}="HWR Steckdose";
$switch{'omd.3.6'}="Lea Steckdose";
$switch{'omd.7.6'}="Wohnzimmer Steckdose Wintergarten 1";
$switch{'omd.7.7'}="Wohnzimmer Steckdose Wintergarten 2";

#
# Options
#
our %opt=();
getopts("cd", \%opt);
if ($opt{h}) {
  printf("Usage: $prog [-cdhlRsT] pdffile[pdfdir]\n");
  printf("    d: debug mode\n");
  printf("    h: help (print this)\n");
  exit 1;
}

# create switches
create_switches();

# create lights
create_lights();

# create sensors
create_sensors();

# create sensors
create_binary_sensors();

# create cover (rollershutter)
create_cover();

exit;

################################################################################
sub create_switches {

  my $file="phc-switch.yaml";
  open(my $fh, '>', $file);
  printf $fh ("#\n");
  printf $fh ("# HA switches provided by phc2mqtt \n");
  printf $fh ("# Generated by Script $prog at %s \n",$now);
  printf $fh ("#\n\n");

  foreach my $s (sort keys %switch) {
    my ($dev_type,$dev_no,$channel)=split(/\./,$s);
	my $device=$dev_type.'.'.$dev_no;
	my $area=(split(/\s/,$switch{$s}))[0];
	my $id=$s;
    my $model=($dev_type eq 'omd' ? "940/24 AM" : "940/24 EM");
    my $pl=($dev_type eq 'omd' ? "out" : "led");
    my $device_class=($dev_type eq 'omd' ? "outlet" : "switch");

    printf $fh ("- object_id: %s\n",$id);
    printf $fh ("  unique_id: %s\n",$id);
    printf $fh ("  name: \"%s\"\n",$switch{$s});
    printf $fh ("  state_topic: \"phc2mqtt/p2m/sta/%s\"\n",$device);
    printf $fh ("  command_topic: \"phc2mqtt/m2p/cmd/ccmd\"\n");
    printf $fh ("  payload_on: \"%s.%s%s.on\"\n",$device,$pl,$channel);
    printf $fh ("  payload_off: \"%s.%s%s.off\"\n",$device,$pl,$channel);

    printf $fh ("  value_template: > \n");
    printf $fh ("    {%% if '%s%s' in value_json %%}\n",$pl,$channel);
    printf $fh ("      {%% if value_json.%s%s %%} \n",$pl,$channel);
    printf $fh ("        %s.%s%s.on \n",$device,$pl,$channel);
    printf $fh ("      {%% else %%} \n");
    printf $fh ("        %s.%s%s.off \n",$device,$pl,$channel);
    printf $fh ("      {%% endif %%} \n");
    printf $fh ("    {%% endif %%} \n");

    printf $fh ("  optimistic: false\n");
    printf $fh ("  device_class: %s \n",$device_class);
    printf $fh ("  icon: mdi:led-outline \n") if ($dev_type eq 'imd');
    printf $fh ("  device: {\n");
    printf $fh ("    identifiers: [\"%s\"],\n",$s);
    printf $fh ("    name: \"%s\",\n",uc($s));
    printf $fh ("    manufacturer: \"%s\",\n",$manufacturer);
    printf $fh ("    model: \"%s\",\n",$model);
    printf $fh ("    suggested_area: \"%s\"\n",$area);
    printf $fh ("  }\n");
    printf $fh ("\n");

  }
  close $fh;

}

################################################################################
sub create_lights {

  my $file="phc-light.yaml";
  open(my $fh, '>', $file);
  printf $fh ("#\n");
  printf $fh ("# HA lights provided by phc2mqtt \n");
  printf $fh ("# Generated by Script $prog at %s \n",$now);
  printf $fh ("#\n\n");

  foreach my $s (sort keys %light) {
    my ($dev_type,$dev_no,$channel)=split(/\./,$s);
	my $device=$dev_type.'.'.$dev_no;
	my $area=(split(/\s/,$light{$s}))[0];
	my $id=$s;
    my $model="940/24 AM";

    printf $fh ("- object_id: %s\n",$id);
    printf $fh ("  unique_id: %s\n",$id);
    printf $fh ("  name: \"%s\"\n",$light{$s});
    printf $fh ("  state_topic: \"phc2mqtt/p2m/sta/%s\"\n",$device);
    printf $fh ("  command_topic: \"phc2mqtt/m2p/cmd/ccmd\"\n");
    printf $fh ("  payload_on: \"%s.out%s.on\"\n",$device,$channel);
    printf $fh ("  payload_off: \"%s.out%s.off\"\n",$device,$channel);

    printf $fh ("  state_value_template: > \n");
    printf $fh ("    {%% if 'out%s' in value_json %%}\n",$channel);
    printf $fh ("      {%% if value_json.out%s %%} \n",$channel);
    printf $fh ("        %s.out%s.on \n",$device,$channel);
    printf $fh ("      {%% else %%} \n");
    printf $fh ("        %s.out%s.off \n",$device,$channel);
    printf $fh ("      {%% endif %%} \n");
    printf $fh ("    {%% endif %%} \n");


    printf $fh ("  optimistic: false\n");
    printf $fh ("  device: {\n");
    printf $fh ("    identifiers: [\"%s\"],\n",$s);
    printf $fh ("    name: \"%s\",\n",uc($s));
    printf $fh ("    manufacturer: \"%s\",\n",$manufacturer);
    printf $fh ("    model: \"%s\",\n",$model);
    printf $fh ("    suggested_area: \"%s\"\n",$area);
    printf $fh ("  }\n");
    printf $fh ("\n");

  }
  close $fh;

}

################################################################################
sub create_sensors {

  my $file="phc-sensor.yaml";
  open(my $fh, '>', $file);
  printf $fh ("#\n");
  printf $fh ("# HA sensors provided by phc2mqtt \n");
  printf $fh ("# Generated by Script $prog at %s \n",$now);
  printf $fh ("#\n\n");

  foreach my $s (sort keys %sensor) {
    my ($dev_type,$dev_no,$channel)=split(/\./,$s);
	my $device=$dev_type.'.'.$dev_no;
	my $area=(split(/\s/,$sensor{$s}))[0];
	my $id=$s;
    my $model=($dev_type eq 'jrm' ? "940/JRM" : "940/24 EM");

    printf $fh ("- object_id: %s\n",$id);
    printf $fh ("  unique_id: %s\n",$id);
    printf $fh ("  name: \"%s\"\n",$sensor{$s});
    printf $fh ("  state_topic: \"phc2mqtt/p2m/evt/%s\"\n",$device);
    printf $fh ("  value_template: > \n");
    printf $fh ("    {%% if 'in%s' in value_json %%}\n",$channel);
    printf $fh ("      {{ value_json.in%s }} \n",$channel);
    printf $fh ("    {%% else %%} \n");
    printf $fh ("      {{ states(this.entity_id) }} \n");
    printf $fh ("    {%% endif %%} \n");
    printf $fh ("  device: {\n");
    printf $fh ("    identifiers: [\"%s\"],\n",$s);
    printf $fh ("    name: \"%s\",\n",uc($s));
    printf $fh ("    manufacturer: \"%s\",\n",$manufacturer);
    printf $fh ("    model: \"%s\",\n",$model);
    printf $fh ("    suggested_area: \"%s\"\n",$area);
    printf $fh ("  }\n");
    printf $fh ("\n");

  }
  close $fh;

}

################################################################################
sub create_binary_sensors {

  my $file="phc-binary-sensor.yaml";
  open(my $fh, '>', $file);
  printf $fh ("#\n");
  printf $fh ("# HA binary_sensors provided by phc2mqtt \n");
  printf $fh ("# Generated by Script $prog at %s \n",$now);
  printf $fh ("#\n\n");

  foreach my $s (sort keys %binary_sensor) {
    my ($dev_type,$dev_no,$channel)=split(/\./,$s);
	my $device=$dev_type.'.'.$dev_no;
	my $area=(split(/\s/,$binary_sensor{$s}))[0];
	my $id=$s;
    my $model=($dev_type eq 'jrm' ? "940/JRM" : "940/24 EM");
	my $device_class="opening";

    printf $fh ("- object_id: %s\n",$id);
    printf $fh ("  unique_id: %s\n",$id);
    printf $fh ("  name: \"%s\"\n",$binary_sensor{$s});
    printf $fh ("  state_topic: \"phc2mqtt/p2m/+/%s\"\n",$device);
    printf $fh ("  value_template: > \n");
    printf $fh ("    {%% if 'in%s' in value_json %%}\n",$channel);
    printf $fh ("      {%% if value_json.in%s[0] == 'o' or value_json.in%s == 0 %%} \n",$channel,$channel);
    printf $fh ("        ON \n");
    printf $fh ("      {%% else %%} \n");
    printf $fh ("        OFF \n");
    printf $fh ("      {%% endif %%} \n");
    printf $fh ("    {%% endif %%} \n");
    printf $fh ("  device_class: %s \n",$device_class);
    printf $fh ("  device: {\n");
    printf $fh ("    identifiers: [\"%s\"],\n",$s);
    printf $fh ("    name: \"%s\",\n",uc($s));
    printf $fh ("    manufacturer: \"%s\",\n",$manufacturer);
    printf $fh ("    model: \"%s\",\n",$model);
    printf $fh ("    suggested_area: \"%s\"\n",$area);
    printf $fh ("  }\n");
    printf $fh ("\n");

  }
  close $fh;

}
################################################################################
sub create_cover {

  my $file="phc-cover.yaml";
  open(my $fh, '>', $file);
  printf $fh ("#\n");
  printf $fh ("# HA cover provided by phc2mqtt \n");
  printf $fh ("# Generated by Script $prog at %s \n",$now);
  printf $fh ("#\n\n");

  foreach my $s (sort keys %cover) {
    my ($dev_type,$dev_no,$channel)=split(/\./,$s);
	my $device=$dev_type.'.'.$dev_no;
	my $area=(split(/\s/,$cover{$s}))[0];
	my $id=$s;
    my $model="940 JRM";

    printf $fh ("- object_id: %s\n",$id);
    printf $fh ("  unique_id: %s\n",$id);
    printf $fh ("  name: \"%s\"\n",$cover{$s});
    printf $fh ("  command_topic: \"phc2mqtt/m2p/cmd/ccmd\"\n");
    printf $fh ("  payload_open:  \"%s.out%s.toggleup.1.1.%i\"\n",$device,$channel,$time{$id});
    printf $fh ("  payload_close: \"%s.out%s.toggledown.1.1.%i\"\n",$device,$channel,$time{$id});
    printf $fh ("  payload_stop:  \"%s.out%s.stop.1\"\n",$device,$channel,$time{$id});
    printf $fh ("  state_topic: \"phc2mqtt/p2m/evt/%s\"\n",$device);
    printf $fh ("  state_open:   '{\"fb%s\":\"upon\"}'\n",$channel);
    printf $fh ("  state_closed: '{\"fb%s\":\"downon\"}'\n",$channel);
    printf $fh ("  optimistic: false\n");
    printf $fh ("  device: {\n");
    printf $fh ("    identifiers: [\"%s\"],\n",$s);
    printf $fh ("    name: \"%s\",\n",uc($s).' '.$cover{$s});
    printf $fh ("    manufacturer: \"%s\",\n",$manufacturer);
    printf $fh ("    model: \"%s\",\n",$model);
    printf $fh ("    suggested_area: \"%s\"\n",$area);
    printf $fh ("  }\n");
    printf $fh ("\n");

  }
  close $fh;

}

